﻿

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Advent.aiDevices;

namespace Advent.Controls
{
    public partial class StatusCtrl : UserControl
    {
        

        public StatusCtrl()
        {
            InitializeComponent();

            cbo_Units.Items.Clear();
            foreach (SignalLevel.LevelSpecification S in Enum.GetValues(typeof(SignalLevel.LevelSpecification)))
                cbo_Units.Items.Add(S);
            cbo_Units.SelectedIndex = 0;

            this.EnabledChanged += new EventHandler(StatusCtrl_EnabledChanged);
        }

        void StatusCtrl_EnabledChanged(object sender, EventArgs e)
        {
            timer_Update.Enabled = this.Enabled;
            if (!this.Enabled)
            {
                UpdateLineState(Telephone_Line_State.Disconnected,false);
                UpdateBasicMeasurements(SignalLevel.InVrms(0), Frequency.InHz(0), DCVoltage.InVolts(0), DCCurrent.InAmps(0));
            }
        }


        protected virtual void timer_Update_Tick(object sender, EventArgs e)
        {
            // This should be overridden in order to update the status
        }

        /// <summary>
        /// This updates the display with basic measurements
        /// </summary>
        protected void UpdateBasicMeasurements(SignalLevel level,
                                                Frequency Freq,
                                                DCVoltage Voltage,
                                                DCCurrent LoopCurrent)
        {

            // we display the level in the units specified by the combo box
            lbl_AC.Text = level.ToRepresentation((SignalLevel.LevelSpecification)cbo_Units.SelectedItem).ToString()
                        + " @ " + Freq.ToString();

            lbl_DC.Text = Voltage.ToString() + " @ " + LoopCurrent.ToString();


        }


        protected void UpdateLineState(Telephone_Line_State State, bool IsRinging)
        {
            if (IsRinging)
            {
                pic_LineState.Image = Advent.Properties.Resources.Tel_Ringing;
                lbl_LineState.Text = "Ringing";
                return;
            }

            switch (State)
            {
                case Telephone_Line_State.Disconnected:
                    pic_LineState.Image = Advent.Properties.Resources.Tel_Disconnect;
                    break;

                case Telephone_Line_State.In_Use:

                    pic_LineState.Image = Advent.Properties.Resources.Tel_LineInUse;
                    break;

                case Telephone_Line_State.Off_Hook:
                    pic_LineState.Image = Advent.Properties.Resources.Tel_OffHook;
                    break;


                case Telephone_Line_State.On_Hook:
                    pic_LineState.Image = Advent.Properties.Resources.Tel_OnHook;

                    break;

            }
            lbl_LineState.Text = State.ToString().Replace('_', ' ');
        }




    }
}
